function varargout = GISsimulator(varargin)
% GISSIMULATOR_DEVELOPER M-filemenu for GISsimulator.fig
%      GISSIMULATOR_DEVELOPER, by itself, creates a new GISSIMULATOR_DEVELOPER or raises the existing
%      singleton*.
%
%      H = GISSIMULATOR_DEVELOPER returns the handle to a new GISSIMULATOR_DEVELOPER or the handle to
%      the existing singleton*.
%
%      GISSIMULATOR_DEVELOPER('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in GISSIMULATOR_DEVELOPER.M with the given input arguments.
%
%      GISSIMULATOR_DEVELOPER('Property','Value',...) creates a new GISSIMULATOR_DEVELOPER or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before GISsimulator_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to GISsimulator_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to helpmenu GISsimulator

% Last Modified by GUIDE v2.5 18-Jun-2008 17:07:11

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
    'gui_Singleton',  gui_Singleton, ...
    'gui_OpeningFcn', @GISsimulator_OpeningFcn, ...
    'gui_OutputFcn',  @GISsimulator_OutputFcn, ...
    'gui_LayoutFcn',  [] , ...
    'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT

% --- Executes just before GISsimulator is made visible.
function GISsimulator_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to GISsimulator (see VARARGIN)

handles.output_fname = 'Test_';

tmp_dname = [pwd '\Data'];
tmp_dname(strfind(tmp_dname, '\')) = '/';
handles.output_dname = tmp_dname;
set(findobj('Tag','output_dname'), 'String', tmp_dname);
clear tmp_dname;

handles.version = '1.5';

tmp_version = handles.version;
tmp_version(strfind(tmp_version, '.')) = 'c';
handles.application = ['PrecursorDistribution_' tmp_version '.exe'];
handles.getconfig = ['GetConfiguration_' tmp_version '.exe'];
%handles.application_path = ['PrecursorDistribution_' tmp_version '/'];
%handles.configuration_path = ['GetConfiguration_' tmp_version '/'];
clear tmp_version tmp_version_ind;

set(findobj('Tag','comment'), 'String', [date ' ']);
handles.comment = date;

handles.molecules = 1e6;
handles.config_set = 1;
handles.angle1 = 0;
handles.angle2 = 60;
handles.distance = 5;
handles.tube_length = 5;
handles.exit_tilt = 0;
handles.check_hole = 0;
handles.hole_z = 3;
handles.hole_tilt = 0;
handles.hole_radius = 0.5;
handles.hole_TC = 1;
handles.check_free = 1;
handles.MFP_in = 1;
handles.check_decay = 0;
handles.DeltaP = 10;
handles.uptake = 0;
handles.gridsize = 64;
handles.imagesize = 12;
handles.virtual_planes = 50;
handles.AngleDistrCenterX = 0;
handles.AngleDistrCenterY = 0;
handles.filtersize = 64;
handles.ang_res = 1;
handles.seed1 = -964545310;
handles.seed2 = -5416974;
handles.seed3 = -110257687;
handles.seed4 = -64335422;

handles.config_str = '0, 60, 5';
handles.incidence = 60;
handles.tubeheight = 1;
handles.ri = 0.2;
handles.ra = 1.75;

handles.simulation_status = ' ';
handles.simulation_start = ' ';

%AddFullConfig_Callback(hObject, eventdata, handles);
UpdateDisplay(hObject, eventdata, handles);

% Choose default command line output for GISsimulator
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes GISsimulator wait for user response (see UIRESUME)
% uiwait(handles.figure1);

% --- Outputs from this function are returned to the command line.
function varargout = GISsimulator_OutputFcn(hObject, eventdata, handles)
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;

% --------------------------------------------------------------------
function LoadConfigMenuItem_Callback(hObject, eventdata, handles)
%
% read a txt file with config parameters
%
pname_orig = pwd;
[fname,pname] = uigetfile('*.txt', 'Select a <...>Simulation_Summary.txt file');
if fname == 0
    set(findobj('Tag','HelpLine'), 'String', 'Nothing selected!');
elseif length(fname)<22
    set(findobj('Tag','HelpLine'), 'String', 'Select a <...>Simulation_Summary.txt file!');
elseif sum(fname(end-21:end)~='Simulation_Summary.txt')
    set(findobj('Tag','HelpLine'), 'String', 'Select a <...>Simulation_Summary.txt file!');
else
    set(findobj('Tag','HelpLine'), 'String', ['Configuration "' fname(1:end-22) '" loaded']);
    LoadConfig(hObject, eventdata, handles, pname, fname, pname_orig)
end


% ***************************************************************** %
function LoadConfig(hObject, eventdata, handles, pname, fname, pname_orig)

cd(pname);

fid = fopen(fname);

fgetl(fid); fgetl(fid); fgetl(fid); fgetl(fid);
fgetl(fid); fgetl(fid);

fgetl(fid); fgetl(fid);
%fgetl(fid); handles.molecules = fscanf(fid,'%f'); set(findobj('Tag','molecules'), 'String', num2str(handles.molecules*1e-6));

fgetl(fid); handles.config_set = fscanf(fid,'%f');
tmp=handles.config_set;

for i = 1:handles.config_set
    fgetl(fid); handles.angle1(i) = fscanf(fid,'%f');
    fgetl(fid); handles.angle2(i) = fscanf(fid,'%f');
    fgetl(fid); handles.distance(i) = fscanf(fid,'%f');
    if(i == 1)
        tmp_angle1_str = num2str(handles.angle1(i));
        tmp_angle2_str = num2str(handles.angle2(i));
        tmp_distance_str = num2str(handles.distance(i));
    else
        tmp_angle1_str = [tmp_angle1_str ', ' num2str(handles.angle1(i))];
        tmp_angle2_str = [tmp_angle2_str ', ' num2str(handles.angle2(i))];
        tmp_distance_str = [tmp_distance_str ', ' num2str(handles.distance(i))];
    end
end
set(findobj('Tag','distance'), 'String', tmp_distance_str);
set(findobj('Tag','angle1'), 'String', tmp_angle1_str);
set(findobj('Tag','angle2'), 'String', tmp_angle2_str);
clear tmp_distance_str;
clear tmp_angle1_str;
clear tmp_angle2_str;

fgetl(fid); handles.tube_length = fscanf(fid,'%f'); set(findobj('Tag','tube_length'), 'String', num2str(handles.tube_length));
fgetl(fid); handles.exit_tilt = fscanf(fid,'%f'); set(findobj('Tag','exit_tilt'), 'String', num2str(handles.exit_tilt));

fgetl(fid); handles.ra = fscanf(fid,'%f');
set(findobj('Tag','outerradius'), 'String', num2str(handles.ra));

fgetl(fid); handles.check_hole = fscanf(fid,'%f'); set(findobj('Tag','check_hole'), 'Value', handles.check_hole);
fgetl(fid); handles.hole_z = fscanf(fid,'%f'); set(findobj('Tag','hole_z'), 'String', num2str(handles.hole_z));
fgetl(fid); handles.hole_tilt = fscanf(fid,'%f'); set(findobj('Tag','hole_tilt'), 'String', num2str(handles.hole_tilt));
fgetl(fid); handles.hole_radius = fscanf(fid,'%f'); set(findobj('Tag','hole_radius'), 'String', num2str(handles.hole_radius));
fgetl(fid); handles.hole_TC = fscanf(fid,'%f'); set(findobj('Tag','hole_TC'), 'String', num2str(handles.hole_TC));

fgetl(fid); handles.check_free = fscanf(fid,'%f');
fgetl(fid); handles.MFP_in = fscanf(fid,'%f'); set(findobj('Tag','MFP_in'), 'String', num2str(handles.MFP_in));
fgetl(fid); handles.check_decay = fscanf(fid,'%f');
if(handles.check_free == 1)
    tmp_check = 1;
elseif(handles.check_free == 0 || handles.check_decay == 0)
    tmp_check = 2;
elseif(handles.check_free == 0 || handles.check_decay == 1)
    tmp_check = 3;
end
set(findobj('Tag','check_regime'), 'Value', tmp_check);
clear tmp_check;

fgetl(fid); handles.DeltaP = fscanf(fid,'%f'); set(findobj('Tag','DeltaP'), 'String', num2str(handles.DeltaP));
fgetl(fid); handles.uptake = fscanf(fid,'%f'); set(findobj('Tag','uptake'), 'String', num2str(handles.uptake));
fgetl(fid); handles.gridsize = fscanf(fid,'%f'); set(findobj('Tag','gridsize'), 'String', num2str(handles.gridsize));
fgetl(fid); handles.imagesize = fscanf(fid,'%f'); set(findobj('Tag','imagesize'), 'String', num2str(handles.imagesize));
fgetl(fid); handles.virtual_planes = fscanf(fid,'%f'); set(findobj('Tag','virtual_planes'), 'String', num2str(handles.virtual_planes));
fgetl(fid); handles.AngleDistrCenterX = fscanf(fid,'%f'); set(findobj('Tag','AngleDistrCenterX'), 'String', num2str(handles.AngleDistrCenterX));
fgetl(fid); handles.AngleDistrCenterY = fscanf(fid,'%f'); set(findobj('Tag','AngleDistrCenterY'), 'String', num2str(handles.AngleDistrCenterY));
fgetl(fid); handles.filtersize = fscanf(fid,'%f'); set(findobj('Tag','filtersize'), 'String', num2str(handles.filtersize));
fgetl(fid); handles.ang_res = fscanf(fid,'%f'); set(findobj('Tag','ang_res'), 'String', num2str(handles.ang_res));
% loads the original seed value
fgetl(fid); handles.seed1 = fscanf(fid,'%f'); set(findobj('Tag','seed1'), 'String', num2str(handles.seed1));
fgetl(fid); handles.seed2 = fscanf(fid,'%f'); set(findobj('Tag','seed2'), 'String', num2str(handles.seed2));
fgetl(fid); handles.seed3 = fscanf(fid,'%f'); set(findobj('Tag','seed3'), 'String', num2str(handles.seed3));
fgetl(fid); handles.seed4 = fscanf(fid,'%f'); set(findobj('Tag','seed4'), 'String', num2str(handles.seed4));
% new seed values generated from a RNG
%handles.seed1 = -ceil(1e6.*rand(1,1)); set(findobj('Tag','seed1'), 'String', num2str(handles.seed1));
%handles.seed2 = -ceil(1e6.*rand(1,1)); set(findobj('Tag','seed2'), 'String', num2str(handles.seed2));
%handles.seed3 = -ceil(1e6.*rand(1,1)); set(findobj('Tag','seed3'), 'String', num2str(handles.seed3));
%handles.seed4 = -ceil(1e6.*rand(1,1)); set(findobj('Tag','seed4'), 'String', num2str(handles.seed4));
fclose(fid);

% Display the configurationmenu
tmp_pname = pname;
tmp_pname(strfind(tmp_pname,'\'))='/';
[Config_xs Config_ys Config_zs] = textread([tmp_pname fname(1:end-22) 'Configuration.txt'], '%s %s %s', 'whitespace',' ');
clear tmp_pname;

i=1;
l=1;
m=1;
for k = 1:length(Config_xs)
    if m <= length(Config_xs)
        if Config_xs{m} ~= '%'
            Config_x2(i,l) = str2num(Config_xs{m});
            Config_z2(i,l) = str2num(Config_zs{m});
            l = l+1;
        else
            i = i+1;
            l = 1;
        end
        m = m+1;
    end
end

no_disp = i-1;
axes(handles.Display);
plot(Config_x2', Config_z2', '-', 'Linewidth', 2);
axis image;
ylabel('z_s [r]'); xlabel('x_s [r]');

% Choose default command line output for GISsimulator
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

cd(pname_orig);

% --------------------------------------------------------------------
function RunMenuItem_Callback(hObject, eventdata, handles)

if (exist([handles.output_dname '/' handles.output_fname 'Simulation_Summary.txt']) == 2)
    % <...>Simulation_Summary.txt file in the selected directory with the selected base filename already exists

    disp('************************')
    disp('Continued simulation run')
    disp('************************')
    disp(' ')
    cnt = true;

    % load config of existing simulation
    pname_orig = pwd;
    pname = handles.output_dname;
    pname(strfind(pname, '/')) = '\';
    pname = [pname '\'];
    fname = [handles.output_fname 'Simulation_Summary.txt'];

    LoadConfig(hObject, eventdata, handles, pname, fname, pname_orig);

    % sets the Matlab RNG to a state depending on the clock
    rand('state',sum(100*clock))
    % seed values generated by the Matlab RNG
    handles.seed1 = -ceil(1e6.*rand(1,1)); set(findobj('Tag','seed1'), 'String', num2str(handles.seed1));
    handles.seed2 = -ceil(1e6.*rand(1,1)); set(findobj('Tag','seed2'), 'String', num2str(handles.seed2));
    handles.seed3 = -ceil(1e6.*rand(1,1)); set(findobj('Tag','seed3'), 'String', num2str(handles.seed3));
    handles.seed4 = -ceil(1e6.*rand(1,1)); set(findobj('Tag','seed4'), 'String', num2str(handles.seed4));

else

    cnt = false;
    disp('******************')
    disp('New simulation run')
    disp('******************')
    disp(' ')

end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% write parameter file
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
pname = '.\SimulationParameters\parameters.txt';
fid = fopen(pname, 'wt');
fprintf(fid, [handles.output_dname '/' handles.output_fname '\n']);
fprintf(fid,  [handles.version '\n']);
fprintf(fid, [handles.comment '\n' '\n']);
fprintf(fid, '# molecules []\n%f\n', handles.molecules);
fprintf(fid, 'number of configurations\n%f\n', handles.config_set);
for i = 1:handles.config_set
    fprintf(fid, 'angle between exit surface normal and center-origin extension, alpha1 []\n%f\n', handles.angle1(i));
    fprintf(fid, 'angle between exit center-origin extension and substrate normal, alpha2 []\n%f\n', handles.angle2(i));
    fprintf(fid, 'distance from tube exit surface center to substrate origin [r]\n%f\n', handles.distance(i));
end
fprintf(fid, 'tube length [r]\n%f\n', handles.tube_length);
fprintf(fid, 'tilt of plane cutting the tube []\n%f\n', handles.exit_tilt);
fprintf(fid, 'outer radius of the tube [r]\n%f\n', handles.ra);
fprintf(fid, 'hole?\n%f\n', handles.check_hole);
fprintf(fid, 'z position of "hole-"cylinder axis crossing the tube axis [r]\n%f\n', handles.hole_z);
fprintf(fid, 'tilt of "hole-"cylinder axis relative to tube axis []\n%f\n', handles.hole_tilt);
fprintf(fid, 'radius of "hole-"cylinder [r]\n%f\n', handles.hole_radius);
fprintf(fid, 'transmission coefficient of "hole-"cylinder \n%f\n', handles.hole_TC);
fprintf(fid, 'freeflight?\n%f\n', handles.check_free);
fprintf(fid, 'mean free path [r]\n%f\n', handles.MFP_in);
fprintf(fid, 'pressure decay?\n%f\n', handles.check_decay);
fprintf(fid, 'total pressure decay along the tube in percent\n%f\n', handles.DeltaP);
fprintf(fid, 'uptake coefficient (per tube collision!)\n%f\n', handles.uptake);
fprintf(fid, 'gridsize\n%f\n', handles.gridsize);
fprintf(fid, 'imagesize [r]\n%f\n', handles.imagesize);
fprintf(fid, 'Number of virtual planes (including entrance and exit plane)\n%f\n', handles.virtual_planes);
fprintf(fid, 'Angular distribution histogram at x_s [px]\n%f\n', handles.AngleDistrCenterX);
fprintf(fid, 'Angular distribution histogram at y_s [px]\n%f\n', handles.AngleDistrCenterY);
fprintf(fid, 'Neighbours [px]\n%f\n', handles.filtersize);
fprintf(fid, 'Angle step for angular distribution histogram [] (minimal 1)\n%f\n', handles.ang_res);
fprintf(fid, 'seed 1\n%f\n', handles.seed1);
fprintf(fid, 'seed 2\n%f\n', handles.seed2);
fprintf(fid, 'seed 3\n%f\n', handles.seed3);
fprintf(fid, 'seed 4\n%f\n', handles.seed4);
fprintf(fid, 'end');
fclose(fid);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% execute application
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

if (cnt) set(findobj('Tag','simulation_status'), 'String', 'Continued simulation is running');
else set(findobj('Tag','simulation_status'), 'String', 'New simulation is running');
end
start_time = datestr(now);
set(findobj('Tag','simulation_start'), 'String', ['Start: ' start_time]);

%path_original = pwd;
%cd(handles.application_path);
status = dos(handles.application); % calls PrecursorDistribution
%cd(path_original);
if status == 1
    disp([' ']);
    disp(['The application "' handles.application '" could not be executed. Check if it exists in the root directory.']);
    disp([' ']);
else
    set(findobj('Tag','simulation_status'), 'String', 'Follow the command-line instructions');
    set(findobj('Tag','simulation_start'), 'String', ['Start: ' start_time ' End:' datestr(now)]);

    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % read data from files
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    if (exist([handles.output_dname '/' handles.output_fname 'Configuration.txt']) ~= 2)
        disp(' ');
        disp('No data available. Make sure the specified directory exists.');
        disp(' ');
    else
        
        [Config_xs Config_ys Config_zs] = textread([handles.output_dname '/' handles.output_fname 'Configuration.txt'], '%s %s %s', 'whitespace',' ');

        i=1;
        l=1;
        m=1;
        for k = 1:length(Config_xs)
            if m <= length(Config_xs)
                if Config_xs{m} ~= '%'
                    Config_x2(i,l) = str2num(Config_xs{m});
                    Config_z2(i,l) = str2num(Config_zs{m});
                    l = l+1;
                else
                    i = i+1;
                    l = 1;
                end
                m = m+1;
            end
        end
        no_disp = i-1;

        for i  = 1:handles.config_set
            
            % reads <..>Image_Config<..>.txt
            [n_px] = textread([handles.output_dname '/' handles.output_fname 'Image_Config' num2str(i) '.txt']);
            n_px = n_px(:,[1:(end-1)]); %skips the last row (inserted by textread!?)
            n_px_stack(:,:,i) = n_px;

            % reads <..>Profiles_Config<..>.txt
            [xs_pos(:,i) Counts(:,i) CountsCoeff(:,i) Sterr(:,i) SterrRel(:,i) FluxCoeff(:,i)] ...
                = textread([handles.output_dname '/' handles.output_fname 'Profiles_Config' num2str(i) '.txt'], '%f %f %f %f %f %f', 'whitespace',' ', 'headerlines', 1);

            % reads <..>Statistics_export_Config<..>.txt
            [TR TRH BS UT TC MC MolNum LIS(i) LOS(i) TR_LMC TR_LTC TR_DFT DB(i)] ...
                = textread([handles.output_dname '/' handles.output_fname 'Statistics_export_Config' num2str(i) '.txt'], '%f %f %f %f %f %f %f %f %f %f %f %f %f', 'whitespace',' ', 'headerlines', 1);
            
        end
        % reads <..>AngularDistributionHistogram.txt
        [HistoAngle zenithLMC azimuthLMC zenithLTC azimuthLTC zenithDFT azimuthDFT zenithAll azimuthAll] = textread([handles.output_dname '/' handles.output_fname 'AngularDistributionHistogram.txt'], '%f %u %u %u %u %u %u %u %u', 'whitespace',' ', 'headerlines', 1);
        if handles.tube_length > 0
            % reads <..>AngularDistributionHistogram.txt
            [z_pos TRflux BSflux Netflux BSfluxNorm MFPsamplingNorm MFPsectionCount TubeCollCounter CollisionCounter] = textread([handles.output_dname '/' handles.output_fname 'PressureDistribution.txt'], '%f %f %f %f %f %f %f %f %f', 'whitespace',' ', 'headerlines', 1);
        end

        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        % plot preparation
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

        %plot global settings

        color = 'black';
        width = 1;

        %D = input('Enter the tube inner diameter in mm: ');
        R_i = handles.ri;
        disp([' ']);
        %R_i = 1;
        %Da = input('Enter the tube outer diameter in mm: ');
        R_a = handles.ra*handles.ri;
        %disp([' ']);
        %R_a = R_i*1.7;

        for i  = 1:handles.config_set

            xs = R_i*([-handles.imagesize/2:handles.imagesize/(handles.gridsize-1):handles.imagesize/2]);
            ys = xs;
            alpha1 = handles.angle1(i)*pi/180;
            alpha2 = handles.angle2(i)*pi/180;
            alpha = alpha1 + alpha2;
            beta = handles.exit_tilt*pi/180;
            sigma = handles.hole_tilt*pi/180;

            % Intersection of tube inner diameter with the substrate (works
            % only for filemenu_tilt = 0
            %   xs_di_intersect = [-1:0.001:1]*R_i/cos(beta)/cos(alpha);
            %   ys_di_intersect = R_i*sqrt(1-xs_di_intersect.^2/(R_i/cos(beta)/cos(alpha))^2);

            % Normal projection of tube file inner diameter
            xs_di = [-1:0.001:1]*R_i/cos(beta)*cos(alpha);
            ys_di = R_i*sqrt(1-xs_di.^2/(R_i/cos(beta)*cos(alpha))^2);
            xs_di = xs_di - handles.distance(i)*R_i*sin(alpha2); %ellipse shift to projection center

            % Normal projection of tube file outer diameter
            xs_da = [-1:0.001:1]*R_a/cos(beta)*cos(alpha);
            ys_da = R_a*sqrt(1-xs_da.^2/(R_a/cos(beta)*cos(alpha))^2);
            xs_da = xs_da - handles.distance(i)*R_i*sin(alpha2); %ellipse shift to projection center

            % Normal projection of hole
            xs_dh = [-1:0.001:1]*handles.hole_radius*R_i/cos(sigma)*sin(pi/2-alpha-beta+sigma);
            ys_dh = handles.hole_radius*R_i*sqrt(1-xs_dh.^2/(handles.hole_radius*R_i/cos(sigma)*sin(pi/2-alpha-beta+sigma))^2);
            xs_dh = xs_dh - (handles.tube_length-handles.hole_z)*R_i*sin(alpha+beta) - handles.distance(i)*R_i*sin(alpha) + R_i/cos(sigma)*sin(pi/2-alpha-beta+sigma); %ellipse shift to projection center

            xs_pos_center2 = -handles.distance(i)*R_i*sin(alpha2)*[1 1];
            ys_pos = [-1/2 1/2]*R_i*handles.imagesize;
            ys_pos_short = [-1.1 1.1]*R_a;
            x_axis = [-1/2 1/2]*R_i*handles.imagesize;

            %44444444444444444444444444444444444444444444444444444444444
            HistRes = handles.ang_res;
            max_zenith = max(zenithAll)/sum(zenithAll)/HistRes;
            %CosineSum = sum(sin(2*HistoAngle(find(HistoAngle<=90))*pi/180));
            CosineSum = 180/pi/HistRes;

            %555555555555555555555555555555555555555555555555555555555555
            zenithAll_projected = zenithAll/2./sin(HistoAngle*pi/180);

            %path_current = pwd;
            %path_end = find(handles.output_dname '/' handles.output_fname == '/', 1, 'last');
            %cd(handles.output_dname '/' handles.output_fname(1:path_end));
            %output_dname = handles.output_dname '/' handles.output_fname(path_end+1:end);

            %cd(path_current);

            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            % save data
            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

            fnamesave = [handles.output_dname '/' handles.output_fname 'Config' num2str(i) '_workspace.mat'];
            save(fnamesave);
            %disp([handles.output_fname 'Config' num2str(i) '_workspace.mat saved!'])
            %disp([' ']);

%             yn = input('Save projected tube data? (y/n): ', 's');
%             disp([' ']);
%             if yn == 'y'
%                 out = [[xs_pos_center2 xs_pos_center2(1) xs_di fliplr(xs_di) xs_di(1) xs_da(1) xs_da fliplr(xs_da) xs_da(1) xs_da(end)]'...
%                     [ys_pos_short 0 ys_di fliplr(-ys_di) 0 0 ys_da fliplr(-ys_da) 0 0]'];
%                 fnamesave = [handles.output_dname '/' handles.output_fname 'Config' num2str(i) '_ProjectedTubeData.txt'];
%                 save(fnamesave,'out','-ASCII')
%                 clear out;
%             end

        end

        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        % plot data
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

        %%%%%%%%%%%%%%%%%%%%%%%%%% Data of several configurations is plotted within one figure %%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        
        %DISPLAY PLOT %%%%%%%%%%%%%%%%%%%%%%%%%%%%%

        %1 1 1
        figure(1);
        plot(Config_x2'*R_i, Config_z2'*R_i, '-', 'Linewidth', 2);
        axis image;
        set(gca, 'Box', 'on', 'FontSize', 10)
        ylabel('z_s [mm]', 'FontSize', 12);
        xlabel('x_s [mm]', 'FontSize', 12);

        %         yn = input('Save Config plot? (y/n): ', 's');
        %         disp([' ']);
        %         if yn == 'y'
        %             figure(1);
        %             saveas(gcf,[handles.output_dname '/' handles.output_fname 'Config.jpeg'])
        %         end

        % PROFILE PLOTS %%%%%%%%%%%%%%%%%%%%%%%%

        %11 11 11
        figure(11);
        hold on;
        for i  = 1:handles.config_set
            errorbar(xs_pos(:,i)*R_i, FluxCoeff(:,i), Sterr(:,i)*pi/(handles.imagesize/handles.gridsize)^2, '-k');
        end
        title(['Profile along y_s = 0 (px size ' num2str(1e3*handles.imagesize/handles.gridsize*R_i,3) 'x' num2str(1e3*handles.imagesize/handles.gridsize*R_i,3) ' \mum^2)']);
        set(gca, 'Box', 'on', 'FontSize', 10)
        ylabel('Flux J/J_{tot}', 'FontSize', 12);
        xlabel('x_s [mm]', 'FontSize', 12);
        hold off;


        %12 12 12
        figure(12);
        hold on
        for i  = 1:handles.config_set
            plot(xs_pos(:,i)*R_i, FluxCoeff(:,i), '.');
            Angle1 = handles.angle1(i)*pi/180;
            Angle2 = handles.angle2(i)*pi/180;
            Angle = Angle1+Angle2;
            if handles.distance(i) ~= 0 && handles.exit_tilt == 0
                for ind = 1:length(xs_pos(:,i))
                    if xs_pos(ind,i) == 0
                        sigma(ind) = 0;
                    else
                        Delta = (handles.distance(i)*cos(Angle2))/cos(Angle);
                        sigma(ind) = atan(cos(Angle)./(Delta./xs_pos(ind,i)+sin(Angle)));
                    end
                end
                I_x = (cos(sigma+Angle)/cos(Angle)).^2.*cos(sigma).*cos(sigma+Angle);
                I_x(find(I_x < 0)) = 0;
                plot(xs_pos(:,i)*R_i + handles.distance(i)*(cos(Angle2)*tan(Angle)-sin(Angle2))*R_i, I_x/max(I_x)*max(FluxCoeff(:,i)));
            end
        end
        set(gca, 'Box', 'on', 'FontSize', 10)
        title(['Profile along y_s = 0 (px size ' num2str(1e3*handles.imagesize/handles.gridsize*R_i,3) 'x' num2str(1e3*handles.imagesize/handles.gridsize*R_i,3) ' \mum^2)']);
        ylabel('Flux J/J_{tot}', 'FontSize', 12);
        xlabel('x_s [mm]', 'FontSize', 12);
        legend('Simulation','Cosine point source \newline (normed to max value)');
        hold off

        % yn = input('Save Profile plot? (y/n): ', 's');
        % disp([' ']);
        % if yn == 'y'
        %   figure(11);
        %   saveas(gcf,[handles.output_dname '/' handles.output_fname 'Profile.jpeg'])
        % end


        % 2D AND 3D PLOTS %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

        %%%%%%%%%%%%%%%%% Data of several configurations is plotted in separated figures %%%%%%%%%%%%%%%%%%%%%%%%%%%%%

        for Config_ind = 1:handles.config_set

            load([handles.output_dname '/' handles.output_fname 'Config' num2str(Config_ind) '_workspace.mat']);

            % 10X
            figure(100+Config_ind);
            hold on;
            contour_lines = 8;
            contour(xs, ys, n_px_stack(:,:,(Config_ind))/TR*pi/(handles.imagesize/handles.gridsize)^2, contour_lines); colormap('jet');
            plot([0 0], ys_pos, color, 'Linewidth', width);
            plot(xs_di, ys_di, [':' color], 'Linewidth', width); plot(xs_di, -ys_di, [':' color], 'Linewidth', width);
            plot(xs_da, ys_da, color, 'Linewidth', width); plot(xs_da, -ys_da, color, 'Linewidth', width);
            if handles.check_hole(1) == 1
                plot(xs_dh, ys_dh, color, 'Linewidth', width); plot(xs_dh, -ys_dh, color, 'Linewidth', width);
            end
            plot(xs_pos_center2, ys_pos_short, color, 'Linewidth', width)
            plot(x_axis, [0 0], color, 'Linewidth', width)
            axis image
            set(gca, 'Box', 'on', 'FontSize', 10)
            title(['Isoflux contour plot of J/J_{tot} (px size ' num2str(1e3*handles.imagesize/handles.gridsize*R_i,3) 'x' num2str(1e3*handles.imagesize/handles.gridsize*R_i,3)...
                ' \mum^2) \newline \alpha_1 = ' num2str(handles.angle1(Config_ind)) ', \alpha_2 = ' num2str(handles.angle2(Config_ind)) ', d = ' num2str(handles.distance(Config_ind)) 'r'])
            xlabel('x_s [mm]', 'FontSize', 12)
            ylabel('y_s [mm]', 'FontSize', 12)
            colorbar
            hold off;

            % %201 201 201
            % figure(201);
            % [C,h] = contourf(xs, ys, n_px_stack(:,:,(1000*angle2_ind+Dist_ind)), 6);
            % axis image; ylabel('y_s [r]'); xlabel('x_s [r]'); colormap('jet'); colorbar;
            % set(h,'ShowText','on','TextStep',get(h,'LevelStep')*2);
            %
            % %301 301 301
            % figure(301);
            % hold on;
            % imagesc(xs, ys, n_px_stack(:,:,(1000*angle2_ind+Dist_ind))/handles.molecules);
            % %plot(50*cos([0:360]*pi/180), 50*sin([0:360]*pi/180), 'black');
            % title(['Fraction of impinging molecules (px size ' num2str(handles.imagesize/handles.gridsize*R_i,3) 'x' num2str(handles.imagesize/handles.gridsize*R_i,3) ...
            %     ' mm^2), Efficiency per check_hole: ' num2str(WaferCount/handles.molecules*100,5) '%']);
            % axis image; ylabel('y_s [mm]'); xlabel('x_s [mm]'); colormap(jet); colorbar;
            % hold off;
            %
            % %401 401 401
            % figure(401);
            % surf(n_px_stack(:,:,(1000*angle2_ind+Dist_ind)));
            % ylabel('y_s [r]'); xlabel('x_s [r]'); colormap(jet); colorbar;

            % yn = input('Save 2D plot? (y/n): ', 's');
            % disp([' ']);
            % if yn == 'y'
            % figure(100+Config_ind);
            % saveas(gcf,pname '/' bname '2D.jpeg'])
            % end

        end

        % ANGULAR PROBABILITY PLOTS %%%%%%%%%%%%%%%%%
        
        %1001 1001 1001
        figure(1001);
        title('Zenith angular probability distribution \newline (solid angle)');
        polar(HistoAngle*pi/180, zenithAll/sum(zenithAll)*CosineSum,'.k');
        axis image;
        set(gca, 'Box', 'on', 'FontSize', 10)
        hold on;
        %polar(HistoAngle(find(HistoAngle<=90))*pi/180, sin(2*HistoAngle(find(HistoAngle<=90))*pi/180), '--red');
        hold off;

        %1002 1002 1002
        figure(1002);
        title('Zenith angular probability distribution \newline (2D projection)');
        polar(HistoAngle*pi/180, zenithAll_projected/max(zenithAll_projected),'.k');
        axis image;
        set(gca, 'Box', 'on', 'FontSize', 10)
        hold on
        %polar(HistoAngle(find(HistoAngle<=90))*pi/180, sin(2*HistoAngle(find(HistoAngle<=90))*pi/180)/2./sin(HistoAngle(find(HistoAngle<=90))*pi/180), '--red');
        %polar(HistoAngle*pi/180,
        %zenithAll/sum(zenithAll)*CosineSum/2./sin(HistoAngle*pi/180),'.-');
        hold off

%         %1003 1003 1003
%         figure(1003);
%         subplot(1,2,1);
%         hold on;
%         title('Zenith angular probability distribution \newline (solid angle) -> polar plot');
%         polar(HistoAngle*pi/180, zenithAll/sum(zenithAll)/HistRes/max_zenith,'.black');
%         polar(HistoAngle(find(HistoAngle<=90))*pi/180, sin(2*HistoAngle(find(HistoAngle<=90))*pi/180), '--red');
%         axis image;
%         hold off;
%         subplot(1,2,2);
%         hold on;
%         title('Zenith angular probability distribution \newline (2D projection) -> polar plot');
%         polar(HistoAngle*pi/180, zenithAll./sin(HistoAngle*pi/180)/max(zenithAll./sin(HistoAngle*pi/180)),'.black');
%         polar(HistoAngle*pi/180, sin(2*HistoAngle*pi/180)/2./sin(HistoAngle*pi/180), '--red');
%         axis image;
%         hold off;

        % %1004 1004 1004
        % figure(1004);
        % title('Azimuthal-angular probability distribution into solid angle2 \newline (Probability per degree)');
        % polar(HistoAngle*pi/180, azimuthAll/sum(azimuthAll)/handles.ang_res);
        % axis image;

        % yn = input('Save angular probability plot? (y/n): ', 's');
        % disp([' ']);
        % if yn == 'y'
        %   figure(1001);
        %   saveas(gcf,[handles.output_dname '/' handles.output_fname 'AngProb.jpeg'])
        % end


        % PRESSURE PLOTS %%%%%%%%%%%%%%%%%%%%%%%%%%%

        if handles.tube_length > 0

            %10001 10001 10001
            figure(10001);
            hold on
            plot(z_pos*R_i, BSflux, '.black');
            plot(z_pos*R_i, TRflux, '.red');
            plot(z_pos*R_i, Netflux, '.blue');
            hold off
            legend('Backscatter flux','Transmission flux', 'Net flux');
            ylabel('Pressure (normed)'); xlabel('x [mm]');

            % yn = input('Save Pressure plot? (y/n): ', 's');
            % disp([' ']);
            % if yn == 'y'
            %     figure(10001);
            %     saveas(gcf,handles.output_dname '/' handles.output_fname 'StaticFlux.jpeg'])
            % end

        end

        %%%%%%%%%%%%%%%%% Data of several configurations is plotted in separated figures %%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%         for (Config_ind = 1:handles.config_set)
% 
%             load([handles.output_dname '/' handles.output_fname 'Config' num2str(Config_ind) '_workspace.mat']);
% 
%                disp('Simulation statistics:');
%                disp(['Total computed: ' num2str(MolNum)]);
%                disp(['Transmitted: ' num2str(TR)]);
%                disp(['Transmitted through hole: ' num2str(TRH)]);
%                disp(['Backscattered: ' num2str(BS)]);
%                disp(['Uptaken: ' num2str(UT)]);
%                disp(['Molecule collisions: ' num2str(MC)]);
%                disp(['Tube collisions: ' num2str(TC)]);
%                disp(['Lost in space: ' num2str(LIS(1000*angle2_ind+Dist_ind))]);
%                disp(['Lost on substrate: ' num2str(LOS(1000*angle2_ind+Dist_ind))]);
%                disp(['Last molecule collision: ' num2str(TR_LMC)]);
%                disp(['Last tube collision: ' num2str(TR_LTC)]);
%                disp(['Direct flight through: ' num2str(TR_DFT)]);
%                disp(['Desorption back into tube: ' num2str(DB) '(' num2str(DB(1000*angle2_ind+Dist_ind)/TR*100) '%)']);
%                disp([' ']);
% 
%             Calculates the impingment percentage onto a spherical substrate (e.g. a wafer)
%                 WaferCount = 0;
%                 n_px = n_px_stack(:,:,(1000*angle2_ind+Dist_ind));
%                 for x_ind = 1 : handles.gridsize
%                     for y_ind = 1 : handles.gridsize
%                         if R_i*handles.imagesize/handles.gridsize*sqrt((x_ind-floor(handles.gridsize/2)+1)^2+(y_ind-floor(handles.gridsize/2)+1)^2) <= 50
%                             WaferCount = WaferCount + n_px(x_ind, y_ind);
%                         end
%                     end
%                 end
%                 disp(['Percentage impinging on the wafer: ' num2str(WaferCount/handles.molecules*100,5)])
%                 disp([' ']);
%             
%         end

        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

        delete(fnamesave);
        
        yn = input('Close figures? (y/n): ', 's');
        if yn == 'y'
            close(figure(1),...
                figure(11), figure(12),...
                figure(101), figure(102), figure(103), figure(104), figure(105), figure(106), figure(107), figure(108),...
                figure(1001), figure(1002), figure(1003), figure(1004),...
                figure(10001));
            %        close all;
        end

    end

    disp([' ']);
    disp(['SIMULATION FINISHED']);
    disp([' ']);

end

set(findobj('Tag','simulation_status'), 'String', 'Ready for new or continued simulation run');
set(findobj('Tag','simulation_start'), 'String', ' ');



% ***************************************************************** %
function UpdateDisplay(hObject, eventdata, handles)

    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % write parameter file
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    pname = '.\SimulationParameters\parameters.txt';
    fid = fopen(pname, 'wt');
    fprintf(fid, [handles.output_dname '/' handles.output_fname '\n']);
    fprintf(fid,  [handles.version '\n']);
    fprintf(fid, [handles.comment '\n' '\n']);
    fprintf(fid, '# molecules []\n%f\n', handles.molecules);
    fprintf(fid, 'number of configurations\n%f\n', handles.config_set);
    for i = 1:handles.config_set
        if length(handles.angle1) == handles.config_set & length(handles.angle2) == handles.config_set & length(handles.distance) == handles.config_set
            fprintf(fid, 'angle between exit surface normal and center-origin extension, alpha1 []\n%f\n', handles.angle1(i));
            fprintf(fid, 'angle between exit center-origin extension and substrate normal, alpha2 []\n%f\n', handles.angle2(i));
            fprintf(fid, 'distance from tube exit surface center to substrate origin [r]\n%f\n', handles.distance(i));
        end
    end
    fprintf(fid, 'tube length [r]\n%f\n', handles.tube_length);
    fprintf(fid, 'tilt of plane cutting the tube []\n%f\n', handles.exit_tilt);
    fprintf(fid, 'outer radius of the tube [r]\n%f\n', handles.ra);
    fprintf(fid, 'hole?\n%f\n', handles.check_hole);
    fprintf(fid, 'z position of "hole-"cylinder axis crossing the tube axis [r]\n%f\n', handles.hole_z);
    fprintf(fid, 'tilt of "hole-"cylinder axis relative to tube axis []\n%f\n', handles.hole_tilt);
    fprintf(fid, 'radius of "hole-"cylinder [r]\n%f\n', handles.hole_radius);
    fprintf(fid, 'transmission coefficient of "hole-"cylinder \n%f\n', handles.hole_TC);
    fprintf(fid, 'freeflight?\n%f\n', handles.check_free);
    fprintf(fid, 'mean free path [r]\n%f\n', handles.MFP_in);
    fprintf(fid, 'pressure decay?\n%f\n', handles.check_decay);
    fprintf(fid, 'total pressure decay along the tube in percent\n%f\n', handles.DeltaP);
    fprintf(fid, 'uptake coefficient (per tube collision!)\n%f\n', handles.uptake);
    fprintf(fid, 'gridsize\n%f\n', handles.gridsize);
    fprintf(fid, 'imagesize [r]\n%f\n', handles.imagesize);
    fprintf(fid, 'Number of virtual planes (including entrance and exit plane)\n%f\n', handles.virtual_planes);
    fprintf(fid, 'Angular distribution histogram at x [px]\n%f\n', handles.AngleDistrCenterX);
    fprintf(fid, 'Angular distribution histogram at y [px]\n%f\n', handles.AngleDistrCenterY);
    fprintf(fid, 'Neighbours [px]\n%f\n', handles.filtersize);
    fprintf(fid, 'Angle step for angular distribution histogram [] (minimal 1)\n%f\n', handles.ang_res);
    fprintf(fid, 'seed 1\n%f\n', handles.seed1);
    fprintf(fid, 'seed 2\n%f\n', handles.seed2);
    fprintf(fid, 'seed 3\n%f\n', handles.seed3);
    fprintf(fid, 'seed 4\n%f\n', handles.seed4);
    fprintf(fid, 'end');
    fclose(fid);

    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % execute application
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    
    %path_original = pwd;
    %cd(handles.configuration_path);
    status = dos(handles.getconfig); % calls GetConfiguration
    %cd(path_original);
    if status == 1
        disp([' ']);
        disp(['The application "' handles.getconfig '" could not be executed. Check if it exists in the root directory.']);
        disp([' ']);
    else

        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        % read data from files
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

        % Display the configurationmenu
        [Config_xs Config_ys Config_zs] = textread([handles.output_dname '/' handles.output_fname 'ConfigurationTmp.txt'], '%s %s %s', 'whitespace',' ');
        delete([handles.output_dname '/' handles.output_fname 'ConfigurationTmp.txt']);

        i=1;
        l=1;
        m=1;
        for k = 1:length(Config_xs)
            if m <= length(Config_xs)
                if Config_xs{m} ~= '%'
                    Config_x2(i,l) = str2num(Config_xs{m});
                    Config_z2(i,l) = str2num(Config_zs{m});
                    l = l+1;
                else
                    i = i+1;
                    l = 1;
                end
                m = m+1;
            end
        end

        no_disp = i-1;
        axes(handles.Display);
        plot(Config_x2', Config_z2', '-', 'Linewidth', 2);
        axis image;
        ylabel('z_s [r]'); xlabel('x_s [r]');

    end
    
% ***************************************************************** %

% ---
function output_fname_Callback(hObject, eventdata, handles)

handles.output_fname = get(hObject,'String');
guidata(hObject,handles);

function output_fname_CreateFcn(hObject, eventdata, handles)

if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% ---
function version_Callback(hObject, eventdata, handles)
tmp2_version = get(hObject,'String');
handles.version = tmp2_version{get(hObject,'Value')};
tmp_version = handles.version;
tmp_version(strfind(tmp_version, '.')) = 'c';
handles.application = ['PrecursorDistribution_' tmp_version '.exe'];
handles.getconfig = ['GetConfiguration_' tmp_version '.exe'];
%set(findobj('Tag','application_path'), 'String', handles.application_path);
clear tmp_version tmp2_version;
guidata(hObject,handles);

function version_CreateFcn(hObject, eventdata, handles)

if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% ---
function comment_Callback(hObject, eventdata, handles)
handles.comment = get(hObject,'String');
guidata(hObject,handles);

function comment_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% ---
function molecules_Callback(hObject, eventdata, handles)
    handles.molecules = str2double(get(hObject,'String'))*1e6;
    guidata(hObject,handles);

function molecules_CreateFcn(hObject, eventdata, handles)
    if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
        set(hObject,'BackgroundColor','white');
    end


% % ---
% function angle1_Callback(hObject, eventdata, handles)
%     angle1_str = get(hObject,'String');
%     ind_comma = find(angle1_str == ',');
%     handles.config_set = length(ind_comma)+1;
%     temp = length(ind_comma);
%     ind_comma(temp+1) = length(angle1_str)+1;
% 
%     for i = 1:handles.config_set
%         if i == 1
%             handles.angle1(i) = str2double(angle1_str(1:ind_comma(i)-1));
%         else
%             handles.angle1(i) = str2double(angle1_str(ind_comma(i)+1:ind_comma(i+1)-1));
%         end
%     end
%     %clear angle2_str;
%     if length(handles.angle1) == handles.config_set & length(handles.angle2) == handles.config_set & length(handles.distance) == handles.config_set
%         UpdateDisplay(hObject, eventdata, handles);
%     end
%     guidata(hObject,handles);

function angle1_CreateFcn(hObject, eventdata, handles)
    if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
        set(hObject,'BackgroundColor','white');
    end


% % ---
% function angle2_Callback(hObject, eventdata, handles)
%     angle2_str = get(hObject,'String');
%     ind_comma = find(angle2_str == ',');
%     handles.config_set = length(ind_comma)+1;
%     temp = length(ind_comma);
%     ind_comma(temp+1) = length(angle2_str)+1;
% 
%     handles.angle2(1) = str2double(angle2_str(1:ind_comma(1)-1));
%     for i = 1:handles.config_set-1
%         handles.angle2(i+1) = str2double(angle2_str(ind_comma(i)+1:ind_comma(i+1)-1));
%     end
%     %clear angle2_str;
%     if length(handles.angle1) == handles.config_set & length(handles.angle2) == handles.config_set & length(handles.distance) == handles.config_set
%         UpdateDisplay(hObject, eventdata, handles);
%     end
%     guidata(hObject,handles);

function angle2_CreateFcn(hObject, eventdata, handles)
    if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
        set(hObject,'BackgroundColor','white');
    end

% % ---
% function distance_Callback(hObject, eventdata, handles)
%     distance_str = get(hObject,'String');
%     ind_comma = find(distance_str == ',');
%     handles.config_set = length(ind_comma)+1;
%     temp = length(ind_comma);
%     ind_comma(temp+1) = length(distance_str)+1;
% 
%     handles.distance(1) = str2double(distance_str(1:ind_comma(1)-1));
%     for i = 1:handles.config_set-1
%         handles.distance(i+1) = str2double(distance_str(ind_comma(i)+1:ind_comma(i+1)-1));
%     end
%     if length(handles.angle1) == handles.config_set & length(handles.angle2) == handles.config_set & length(handles.distance) == handles.config_set
%         UpdateDisplay(hObject, eventdata, handles);
%     end
%     guidata(hObject,handles);
% 
function distance_CreateFcn(hObject, eventdata, handles)
    if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
        set(hObject,'BackgroundColor','white');
    end

% ---
function tube_length_Callback(hObject, eventdata, handles)
handles.tube_length = str2double(get(hObject,'String'));
UpdateDisplay(hObject, eventdata, handles);
guidata(hObject,handles);

function tube_length_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% ---
function exit_tilt_Callback(hObject, eventdata, handles)
handles.exit_tilt = str2double(get(hObject,'String'));
UpdateDisplay(hObject, eventdata, handles);
guidata(hObject,handles);

function exit_tilt_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% ---
function hole_z_Callback(hObject, eventdata, handles)
handles.hole_z = str2double(get(hObject,'String'));
UpdateDisplay(hObject, eventdata, handles);
guidata(hObject,handles);

function hole_z_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% ---
function hole_tilt_Callback(hObject, eventdata, handles)
handles.hole_tilt = str2double(get(hObject,'String'));
UpdateDisplay(hObject, eventdata, handles);
guidata(hObject,handles);

function hole_tilt_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% ---
function hole_radius_Callback(hObject, eventdata, handles)
handles.hole_radius = str2double(get(hObject,'String'));
UpdateDisplay(hObject, eventdata, handles);
guidata(hObject,handles);

function hole_radius_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% ---
function hole_TC_Callback(hObject, eventdata, handles)
handles.hole_TC = str2double(get(hObject,'String'));
UpdateDisplay(hObject, eventdata, handles);
guidata(hObject,handles);

function hole_TC_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% ---
function MFP_in_Callback(hObject, eventdata, handles)
handles.MFP_in = str2double(get(hObject,'String'));
guidata(hObject,handles);

function MFP_in_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% ---
function DeltaP_Callback(hObject, eventdata, handles)
handles.DeltaP = str2double(get(hObject,'String'))
guidata(hObject,handles);

function DeltaP_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% ---
function uptake_Callback(hObject, eventdata, handles)
handles.uptake = str2double(get(hObject,'String'));
guidata(hObject,handles);

function uptake_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% ---
function gridsize_Callback(hObject, eventdata, handles)
handles.gridsize = str2double(get(hObject,'String'));
guidata(hObject,handles);

function gridsize_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% ---
function imagesize_Callback(hObject, eventdata, handles)
handles.imagesize = str2double(get(hObject,'String'));
UpdateDisplay(hObject, eventdata, handles);
guidata(hObject,handles);

function imagesize_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% ---
function virtual_planes_Callback(hObject, eventdata, handles)
handles.virtual_planes = str2double(get(hObject,'String'));
guidata(hObject,handles);

function virtual_planes_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% ---
function AngleDistrCenterX_Callback(hObject, eventdata, handles)
handles.AngleDistrCenterX = str2double(get(hObject,'String'));
guidata(hObject,handles);

function AngleDistrCenterX_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% ---
function AngleDistrCenterY_Callback(hObject, eventdata, handles)
handles.AngleDistrCenterY = str2double(get(hObject,'String'));
guidata(hObject,handles);

function AngleDistrCenterY_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% ---
function filtersize_Callback(hObject, eventdata, handles)
handles.filtersize = str2double(get(hObject,'String'));
guidata(hObject,handles);

function filtersize_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% ---
function ang_res_Callback(hObject, eventdata, handles)
handles.ang_res = str2double(get(hObject,'String'));
guidata(hObject,handles);

function ang_res_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% ---
function seed1_Callback(hObject, eventdata, handles)
handles.seed1 = str2double(get(hObject,'String'));
guidata(hObject,handles);

function seed1_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% ---
function seed2_Callback(hObject, eventdata, handles)
handles.seed2 = str2double(get(hObject,'String'));
guidata(hObject,handles);

function seed2_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% ---
function seed3_Callback(hObject, eventdata, handles)
handles.seed3 = str2double(get(hObject,'String'));
guidata(hObject,handles);

function seed3_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function seed4_Callback(hObject, eventdata, handles)
handles.seed4 = str2double(get(hObject,'String'));
guidata(hObject,handles);

function seed4_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% --- Executes during object creation, after setting all properties.
function Display_CreateFcn(hObject, eventdata, handles)

% --- Executes on mouse press over axes background.
function Display_ButtonDownFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% --- Executes during object deletion, before destroying properties.
function Display_DeleteFcn(hObject, eventdata, handles)

function simulation_status_Callback(hObject, eventdata, handles)
handles.simulation_status = str2double(get(hObject,'String'));
guidata(hObject,handles);

% --- Executes during object creation, after setting all properties.
function simulation_status_CreateFcn(hObject, eventdata, handles)
%if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
%    set(hObject,'BackgroundColor','white');
%end

function simulation_start_Callback(hObject, eventdata, handles)
handles.simulation_start = str2double(get(hObject,'String'));
guidata(hObject,handles);

% --- Executes during object creation, after setting all properties.
function simulation_start_CreateFcn(hObject, eventdata, handles)
%if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
%    set(hObject,'BackgroundColor','white');
%end

function output_dname_Callback(hObject, eventdata, handles)
handles.output_dname = str2double(get(hObject,'String'));
guidata(hObject,handles);

% --- Executes during object creation, after setting all properties.
function output_dname_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% --- Executes on selection change in check_regime.
function check_regime_Callback(hObject, eventdata, handles)
tmp_check_free = get(hObject,'Value');
if(tmp_check_free == 1)
    handles.check_free = 1;
elseif(tmp_check_free == 2)
    handles.check_free = 0;
    handles.check_decay = 0;
elseif(tmp_check_free == 3)
    handles.check_free = 0;
    handles.check_decay = 1;
end
clear tmp_check_free;
guidata(hObject,handles);

% --- Executes during object creation, after setting all properties.
function check_regime_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% --- Executes on button press in check_hole.
function check_hole_Callback(hObject, eventdata, handles)
handles.check_hole = get(hObject,'Value');
UpdateDisplay(hObject, eventdata, handles);
guidata(hObject,handles);

% --- Executes during object creation, after setting all properties.
function HelpLine_CreateFcn(hObject, eventdata, handles)

% ---
function InnerRadius_Callback(hObject, eventdata, handles)
handles.ri = 1e-3*str2double(get(hObject,'String'));
UpdateDisplay(hObject, eventdata, handles);
guidata(hObject,handles);

function InnerRadius_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% ---
function OuterRadius_Callback(hObject, eventdata, handles)
handles.ra = str2double(get(hObject,'String'));
UpdateDisplay(hObject, eventdata, handles);
guidata(hObject,handles);

function OuterRadius_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% --- Executes on button press in ClearButton.
function ClearButton_Callback(hObject, eventdata, handles)
set(findobj('Tag','angle1'), 'String', ' ');
handles.angle1 = ' ';
set(findobj('Tag','angle2'), 'String', ' ');
handles.angle2 = ' ';
set(findobj('Tag','distance'), 'String', ' ');
handles.distance = ' ';

handles.config_set = 0;

axes(handles.Display);
plot(0, 0, 'w');

guidata(hObject,handles);

% --- Executes on button press in AddConfig.
function AddConfig_Callback(hObject, eventdata, handles)

    tmp_distance = sqrt((handles.tubeheight + handles.ra*sin(handles.incidence*pi/180))^2 + (handles.ra*cos(handles.incidence*pi/180))^2);

    if handles.distance == ' '
        handles.distance = tmp_distance;
        tmpstr_distance = num2str(tmp_distance,4);
    else
        handles.distance(end+1) = tmp_distance;
        tmpstr_distance = num2str(handles.distance(1),4);
        for i = 1:length(handles.distance)-1
            tmpstr_distance = [tmpstr_distance ', ' num2str(handles.distance(i+1),4)];
        end
        dist = handles.distance;
    end
    set(findobj('Tag','distance'), 'String', tmpstr_distance);

    if handles.incidence == 0 && handles.tubeheight == 0
        tmp_angle1 = -90;
    else
        tmp_angle1 = handles.incidence - atan(handles.ra*cos(handles.incidence*pi/180)/(handles.tubeheight + handles.ra*sin(handles.incidence*pi/180)))*180/pi;
    end
    if handles.angle1 == ' '
        handles.angle1 = tmp_angle1;
        tmpstr_angle1 = num2str(tmp_angle1,4);
    else
        handles.angle1(end+1) = tmp_angle1;
        tmpstr_angle1 = num2str(handles.angle1(1),4);
        for i = 1:length(handles.angle1)-1
            tmpstr_angle1 = [tmpstr_angle1 ', ' num2str(handles.angle1(i+1),4)];
        end
    end
    set(findobj('Tag','angle1'), 'String', tmpstr_angle1);

    tmp_angle2 = handles.incidence - tmp_angle1;
    if handles.angle2 == ' '
        handles.angle2 = tmp_angle2;
        tmpstr_angle2 = num2str(tmp_angle2,4);
    else
        handles.angle2(end+1) = tmp_angle2;
        tmpstr_angle2 = num2str(handles.angle2(1),4);
        for i = 1:length(handles.angle2)-1
            tmpstr_angle2 = [tmpstr_angle2 ', ' num2str(handles.angle2(i+1),4)];
        end
    end
    set(findobj('Tag','angle2'), 'String', tmpstr_angle2);

    clear tmp_distance;
    clear tmp_angle1;
    clear tmp_angle2;
    clear tmpstr_distance;
    clear tmpstr_angle1;
    clear tmpstr_angle2;

    handles.config_set = length(handles.distance);

    UpdateDisplay(hObject, eventdata, handles);

    guidata(hObject,handles);


% ---
function FullConfig_Callback(hObject, eventdata, handles)
    handles.config_str = get(hObject,'String');

    guidata(hObject,handles);
    
% --- Executes during object creation, after setting all properties.
function FullConfig_CreateFcn(hObject, eventdata, handles)
    if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
        set(hObject,'BackgroundColor','white');
    end

    
% --- Executes on button press in AddFullConfig.
function AddFullConfig_Callback(hObject, eventdata, handles)

    if length(find(handles.config_str == ',')) == 2
        ind_comma = find(handles.config_str == ',');
        %    handles.config_set = length(ind_comma)+1;
        ind_comma(length(ind_comma)+1) = length(handles.config_str)+1;

        tmp_angle1 = str2double(handles.config_str(1:ind_comma(1)-1));
        tmp_angle2 = str2double(handles.config_str(ind_comma(1)+1:ind_comma(2)-1));
        tmp_distance = str2double(handles.config_str(ind_comma(2)+1:ind_comma(3)-1));
        
        if handles.distance == ' '
            handles.distance = tmp_distance;
            tmpstr_distance = num2str(tmp_distance);
        else
            handles.distance(end+1) = tmp_distance;
            tmpstr_distance = num2str(handles.distance(1));
            for i = 1:length(handles.distance)-1
                tmpstr_distance = [tmpstr_distance ', ' num2str(handles.distance(i+1))];
            end
            dist = handles.distance;
        end
        set(findobj('Tag','distance'), 'String', tmpstr_distance);

        if handles.angle1 == ' '
            handles.angle1 = tmp_angle1;
            tmpstr_angle1 = num2str(tmp_angle1);
        else
            handles.angle1(end+1) = tmp_angle1;
            tmpstr_angle1 = num2str(handles.angle1(1));
            for i = 1:length(handles.angle1)-1
                tmpstr_angle1 = [tmpstr_angle1 ', ' num2str(handles.angle1(i+1))];
            end
        end
        set(findobj('Tag','angle1'), 'String', tmpstr_angle1);

        if handles.angle2 == ' '
            handles.angle2 = tmp_angle2;
            tmpstr_angle2 = num2str(tmp_angle2);
        else
            handles.angle2(end+1) = tmp_angle2;
            tmpstr_angle2 = num2str(handles.angle2(1));
            for i = 1:length(handles.angle2)-1
                tmpstr_angle2 = [tmpstr_angle2 ', ' num2str(handles.angle2(i+1))];
            end
        end
        set(findobj('Tag','angle2'), 'String', tmpstr_angle2);

        clear tmp_distance;
        clear tmp_angle1;
        clear tmp_angle2;
        clear tmpstr_distance;
        clear tmpstr_angle1;
        clear tmpstr_angle2;

        handles.config_set = length(handles.distance);

        %clear config_str;
        UpdateDisplay(hObject, eventdata, handles);
        guidata(hObject,handles);
    else
        disp('Enter a full configuration set: a1, a2, Ls');
    end


% ---
function incidence_Callback(hObject, eventdata, handles)
handles.incidence = str2double(get(hObject,'String'));
guidata(hObject,handles);

function incidence_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% ---
function TubeHeight_Callback(hObject, eventdata, handles)
handles.tubeheight = str2double(get(hObject,'String'));
guidata(hObject,handles);

function TubeHeight_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Menu in the toolbar %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% --------------------------------------------------------------------
function FileMenu_Callback(hObject, eventdata, handles)
% hObject    handle to FileMenu (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% --------------------------------------------------------------------
function SelectOutputDirMenuItem_Callback(hObject, eventdata, handles)
dirpath = uigetdir('Data');
if dirpath == 0
    set(findobj('Tag','output_dname'), 'String', handles.output_dname);
    clear tmp_dname;
else
    dirpath(strfind(dirpath,'\'))='/';
    %handles.output_dname = dirpath;
    set(findobj('Tag','output_dname'), 'String', dirpath);
    handles.output_dname = dirpath;
    guidata(hObject,handles);
end

% --------------------------------------------------------------------
function ExitMenuItem_Callback(hObject, eventdata, handles)
quit

% --------------------------------------------------------------------
function ConfigurationMenu_Callback(hObject, eventdata, handles)
% hObject    handle to ConfigurationMenu (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% --------------------------------------------------------------------
function SimulationMenu_Callback(hObject, eventdata, handles)
% hObject    handle to SimulationMenu (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% --------------------------------------------------------------------
function HelpMenu_Callback(hObject, eventdata, handles)
% hObject    handle to HelpMenu (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% --------------------------------------------------------------------
function ShowDefinitionsMenuItem_Callback(hObject, eventdata, handles)
figure(99);
imshow('HelpConfig.jpg','Border', 'tight');
%imshow('HelpConfig.jpg');

% --------------------------------------------------------------------
function UseRestrectionsMenuItem_Callback(hObject, eventdata, handles)
figure(999);
imshow('UseRestrictions.jpg','Border', 'tight');
%imshow('UseRestrictions.jpg');

% --------------------------------------------------------------------
function AboutMenuItem_Callback(hObject, eventdata, handles)
figure(9999);
imshow('About.jpg','Border', 'tight');
%imshow('About.jpg');


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% HelpMenu text upon right mouse-click %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% --- If Enable == 'on', executes on mouse press in 5 pixel border.
% --- Otherwise, executes on mouse press in 5 pixel border or over MFP_in.

function version_ButtonDownFcn(hObject, eventdata, handles)
set(findobj('Tag','HelpLine'), 'String','')

function output_dname_ButtonDownFcn(hObject, eventdata, handles)
set(findobj('Tag','HelpLine'), 'String','Use <File>/<Select output directory>.')

function output_fname_ButtonDownFcn(hObject, eventdata, handles)
set(findobj('Tag','HelpLine'), 'String', ['Specifies the base filename of the output data (.txt files). A previousley performed simulation is continued and '...
    'updated if the here specified base filename as well as the output directory are equivalent to the previous settings.'])

function comment_ButtonDownFcn(hObject, eventdata, handles)
set(findobj('Tag','HelpLine'), 'String','Comment is added to the <..>Simulation_Summary.txt output file.')

function molecules_ButtonDownFcn(hObject, eventdata, handles)
set(findobj('Tag','HelpLine'), 'String','Molecules # (x 1e6): Number of transmitted molecules to be computed in the next simulation run.')

function InnerRadius_ButtonDownFcn(hObject, eventdata, handles)
set(findobj('Tag','HelpLine'), 'String', ['Tube inner radius [micrometers]: The raw simulation data (.txt output files) is given in units of '...
    'inner tube radius r. The here specified value is used to plot data at an absolute scale.']);

function OuterRadius_ButtonDownFcn(hObject, eventdata, handles)
set(findobj('Tag','HelpLine'), 'String', ['Tube outer radius [r]: The here specified value is used to calculate the height h of the '...
    'bottom tube edge to the substrate and the distance of the upper tube edge to x_s = 0.']);

function seed1_ButtonDownFcn(hObject, eventdata, handles)
set(findobj('Tag','HelpLine'), 'String', ['RNG seed values: Seed values for four nested random number generators (RNGs). Random seed values are '...
    'generated automatically when a simulation run is continued. Values must be negative integers.']);

function seed2_ButtonDownFcn(hObject, eventdata, handles)
set(findobj('Tag','HelpLine'), 'String', ['RNG seed values: Seed values for four nested random number generators (RNGs). Random seed values are '...
    'generated automatically when a simulation run is continued. Values must be negative integers.']);

function seed3_ButtonDownFcn(hObject, eventdata, handles)
set(findobj('Tag','HelpLine'), 'String', ['RNG seed values: Seed values for four nested random number generators (RNGs). Random seed values are '...
    'generated automatically when a simulation run is continued. Values must be negative integers.']);

function seed4_ButtonDownFcn(hObject, eventdata, handles)
set(findobj('Tag','HelpLine'), 'String', ['RNG seed values: Seed values for four nested random number generators (RNGs). Random seed values are '...
    'generated automatically when a simulation run is continued. Values must be negative integers.']);

function tube_length_ButtonDownFcn(hObject, eventdata, handles)
set(findobj('Tag','HelpLine'), 'String','Tube length [r]: Length of the tube axis.')

function exit_tilt_ButtonDownFcn(hObject, eventdata, handles)
set(findobj('Tag','HelpLine'), 'String','Tube bevel angle []: Defines the cut angle in case of a beveled tube end.')

function check_hole_ButtonDownFcn(hObject, eventdata, handles)
set(findobj('Tag','HelpLine'), 'String',['If enabled, a hole in the tube wall is simulated according to the specifications below. This hole is '...
    'simulated as a surface having an uptake probability specified by the hole transmission coefficient.'])

function hole_z_ButtonDownFcn(hObject, eventdata, handles)
set(findobj('Tag','HelpLine'), 'String','Hole z position [r]: Specifies the the hole axis intersection with the tube axis.')

function hole_tilt_ButtonDownFcn(hObject, eventdata, handles)
set(findobj('Tag','HelpLine'), 'String','Hole tilt []: Specifies the tilt angle of the hole axis relative to the tube axis.')

function hole_radius_ButtonDownFcn(hObject, eventdata, handles)
set(findobj('Tag','HelpLine'), 'String','Hole radius [r]: Specifies the radius of the hole.')

function hole_TC_ButtonDownFcn(hObject, eventdata, handles)
set(findobj('Tag','HelpLine'), 'String','Hole TransCoeff: Transmission coefficient (probability 0..1) of molecules entering the hole.')

function incidence_ButtonDownFcn(hObject, eventdata, handles)
set(findobj('Tag','HelpLine'), 'String', ['"<=" adds the configuration with tube incidence angle a and height h. The upper tube edge '...
    '(outer diameter) is aligned to x_s = 0. See <Help>/<Show definitions>.']);

function TubeHeight_ButtonDownFcn(hObject, eventdata, handles)
set(findobj('Tag','HelpLine'), 'String', ['"<=" adds the configuration with tube incidence angle a and height h. The upper tube edge '...
    '(outer diameter) is aligned to x_s = 0. See <Help>/<Show definitions>.']);

function FullConfig_ButtonDownFcn(hObject, eventdata, handles)
set(findobj('Tag','HelpLine'), 'String', ['"<=" adds the configuration specified by the angles a1, a2 and the distance Ls from the center '...
    'of the tube exit surface to the substrate origin x_s = y_s = 0. See <Help>/<Show definitions>.']);

function check_regime_ButtonDownFcn(hObject, eventdata, handles)
set(findobj('Tag','HelpLine'), 'String',['Specification of the flow regime simulated inside the tube. Molecular flow: no intermolecular '...
    'collisions. Transient flow: intermolecular collisions according to the specified mean free path.'])

function MFP_in_ButtonDownFcn(hObject, eventdata, handles)
set(findobj('Tag','HelpLine'), 'String', 'Mean free path [r]: Specifies the mean distance travelled by a molecule without intermolecular collision.');

function DeltaP_ButtonDownFcn(hObject, eventdata, handles)
set(findobj('Tag','HelpLine'), 'String', 'Pressure Decay [%]: Is used only in the transient flow regime employing the pressure decay model.');

function uptake_ButtonDownFcn(hObject, eventdata, handles)
set(findobj('Tag','HelpLine'), 'String',['Uptake coeff per coll.: Surface uptake coefficient (probability 0..1) for each molecule collision '...
    'with the tube wall. In case of an uptake the molecule trajectory is canceled from the simulation.'])

function imagesize_ButtonDownFcn(hObject, eventdata, handles)
set(findobj('Tag','HelpLine'), 'String',['Sampling field size [r]: Specifies the length and width of the quadratic field for precursor '...
    'distribution sampling on the substrate.'])

function gridsize_ButtonDownFcn(hObject, eventdata, handles)
set(findobj('Tag','HelpLine'), 'String',['Sampling grid points #: The number of gridpoints specifies the sampled pixel size in the substrate '...
    'sampling field: px = "Sampling field size"/"Grid points"'])

function virtual_planes_ButtonDownFcn(hObject, eventdata, handles)
set(findobj('Tag','HelpLine'), 'String',['Sampling planes #: Number of virtual boundaries distributed along the tube. Used for flux/density '...
    '(pressure) sampling inside the tube.'])

function AngleDistrCenterX_ButtonDownFcn(hObject, eventdata, handles)
set(findobj('Tag','HelpLine'), 'String','Center position x [px]: Center (along x-direction) of the field in units of pixels for angular distribution sampling.')

function AngleDistrCenterY_ButtonDownFcn(hObject, eventdata, handles)
set(findobj('Tag','HelpLine'), 'String','Center position y [px]: Center (along y-direction) of the field in units of pixels for angular distribution sampling.')

function filtersize_ButtonDownFcn(hObject, eventdata, handles)
set(findobj('Tag','HelpLine'), 'String',['Sampling field size [px]: Specifies the length and width of the quadratic field in units of pixels for angular distribution '...
    'sampling on the substrate.'])
    
function ang_res_ButtonDownFcn(hObject, eventdata, handles)
set(findobj('Tag','HelpLine'), 'String','Angle resolution []: Specifies the angular steps for the distribution histogram, minimal value 1')


